/*	Renegade Scripts.dll
	Example Plugin Code
	Copyright 2007 Whitedragon(MDB), Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

/*  This is designed to serve as both an example on how to make a plugin and to give users the basic framework of a plugin.
    The plugin is simple: it creates an object creation hook and attaches the script "Plugin_Example_Script" to all objects.
	The script prints out a message whenever an object is created or destroyed.
	There are also examples of the new format for bhs.dll hooks.
*/

#include "scripts.h"
#include <stdarg.h>
#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#endif
#include "engine.h"
#include "gmmain.h"
#include "plugin.h"



void Plugin_Load() 
{
	ConsoleCommand::InstallCommands();
}


void Plugin_Unload() {
}

int *CommandsCount;
ConsoleCommand *CommandsArray;
_SortCommands SortCommands;
_UpdateCommands UpdateCommands;

ConsoleCommand::~ConsoleCommand() {
}

ConsoleCommand::ConsoleCommand() {
	_asm {
		lea eax, this
		push eax
		mov ecx, 0x0081D098
		mov eax, 0x00428FE0
		call eax
	}
}

void ConsoleCommand::InstallCommands() {
	new ConsoleCommand_changecharacter;
	new ConsoleCommand_freeze;
	new ConsoleCommand_flymode;
	new ConsoleCommand_givepoints;
	new ConsoleCommand_kill;
	new ConsoleCommand_refund;
	new ConsoleCommand_setcredits;
	new ConsoleCommand_setpoints;
	new ConsoleCommand_teleport;
	new ConsoleCommand_unfreeze;

	_asm {
		mov eax, 0x00428470 //cleanup and order the console commands
		call eax
	}
	Console_Output("Console commands injected.\n");
};


//************************************************
//*******  CHANGECHARACTER CONSOLE CMD  **********
//************************************************

const char *ConsoleCommand_changecharacter::GetName()
{
	return "changecharacter";
}

const char *ConsoleCommand_changecharacter::GetAlias()
{
	return NULL;
}

const char *ConsoleCommand_changecharacter::GetHelp()
{
	return "CHANGECHARACTER <id> <preset> - Changes a player into any character preset.\n";
}

void ConsoleCommand_changecharacter::Activate(const char *CommandLine)
{
	if (!CommandLine) return;
	if (stricmp(CommandLine, "") == 0)
	{
		Console_Output("CHANGECHARACTER <id> <preset>\n");
		return;
	}
	TokenClass Cmd(CommandLine);
	if (Cmd[0].empty()) { return; }
	if (Cmd[1].empty()) { return; }
	if (Cmd[2].empty()) { return; }
	int pID = atoi(Cmd[1].c_str());
	GameObject *player = Get_GameObj(pID);
	Change_Character(player,Cmd[2].c_str());
}

//************************************************
//***********  FREEZE CONSOLE CMD  ***************
//************************************************

const char *ConsoleCommand_freeze::GetName()
{
	return "freeze";
}

const char *ConsoleCommand_freeze::GetAlias()
{
	return NULL;
}

const char *ConsoleCommand_freeze::GetHelp()
{
	return "FREEZE <id> - Completely immobilizes a player.\n";
}

void ConsoleCommand_freeze::Activate(const char *CommandLine)
{
	if (!CommandLine) return;
	if (stricmp(CommandLine, "") == 0)
	{
		Console_Output("FREEZE <id>\n");
		return;
	}
	TokenClass Cmd(CommandLine);
	if (Cmd[0].empty()) { return; }
	if (Cmd[1].empty()) { return; }
	int pID = atoi(Cmd[1].c_str());
	GameObject *player = Get_GameObj(pID);
	Commands->Control_Enable(player,false);
}

//************************************************
//***********  FLYMODE CONSOLE CMD  **************
//************************************************

const char *ConsoleCommand_flymode::GetName()
{
	return "flymode";
}

const char *ConsoleCommand_flymode::GetAlias()
{
	return NULL;
}

const char *ConsoleCommand_flymode::GetHelp()
{
	return "FLYMODE <id> - Toggles flying on a player.\n";
}

void ConsoleCommand_flymode::Activate(const char *CommandLine)
{
	if (!CommandLine) return;
	if (stricmp(CommandLine, "") == 0)
	{
		Console_Output("FLYMODE <id>\n");
		return;
	}
	TokenClass Cmd(CommandLine);
	if (Cmd[0].empty()) { return; }
	if (Cmd[1].empty()) { return; }
	int pID = atoi(Cmd[1].c_str());
	GameObject *player = Get_GameObj(pID);
	if (!Get_GameObj(pID)) {
		Console_Output("Error: Player not found.\n");
		return;
	}
	else {
		Toggle_Fly_Mode(player);
		Console_Output("Flying mode toggled for player %ls.\n",Get_Wide_Player_Name(player));
	}
}



//************************************************
//**********  GIVEPOINTS CONSOLE CMD  ************
//************************************************

const char *ConsoleCommand_givepoints::GetName()
{
	return "givepoints";
}

const char *ConsoleCommand_givepoints::GetAlias()
{
	return NULL;
}

const char *ConsoleCommand_givepoints::GetHelp()
{
	return "GIVEPOINTS <id> <amount> - Give a player a specified amount of points.\n";
}

void ConsoleCommand_givepoints::Activate(const char *CommandLine)
{	if (!CommandLine) return;
	if (stricmp(CommandLine, "") == 0)
	{
		Console_Output("GIVEPOINTS <id> <amount>\n");
		return;
	}
	TokenClass Cmd(CommandLine);
	if (Cmd[0].empty()) { return; }
	if (Cmd[1].empty()) { return; }
	if (Cmd[2].empty()) { return; }
	int pID = atoi(Cmd[1].c_str());
	float points = (float)atof(Cmd[2].c_str());
	GameObject *player = Get_GameObj(pID);
	Commands->Give_Points(player,points,false);
	Console_Output("%ls has been given %f points.\n",Get_Wide_Player_Name(player),points);
}

//************************************************
//**********  KILLPLAYER CONSOLE CMD  ************
//************************************************

const char *ConsoleCommand_kill::GetName()
{
	return "killplayer";
}

const char *ConsoleCommand_kill::GetAlias()
{
	return NULL;
}

const char *ConsoleCommand_kill::GetHelp()
{
	return "KILLPLAYER <id> - Automatically kills a specified player.\n";
}

void ConsoleCommand_kill::Activate(const char *CommandLine)
{
	if (!CommandLine) return;
	if (stricmp(CommandLine, "") == 0)
	{
		Console_Output("KILLPLAYER <id>\n");
		return;
	}
	int pID = atoi(CommandLine);
	GameObject *obj = Get_GameObj(pID);
	GameObject *Veh = Get_Vehicle(obj);

	if (Veh) {
		if (Get_Vehicle_Driver(Veh) == obj) {
				Commands->Apply_Damage(Veh,99999.0f,"Death",false);
		}
		Commands->Destroy_Object(obj);
	}
	else {
		Commands->Apply_Damage(obj,99999.0f,"Death",false);
	}
	Console_Output("%ls has been force-killed.\n",Get_Wide_Player_Name(obj));
}

//************************************************
//***********  REFUND CONSOLE CMD  ***************
//************************************************

const char *ConsoleCommand_refund::GetName()
{
	return "refund";
}

const char *ConsoleCommand_refund::GetAlias()
{
	return NULL;
}

const char *ConsoleCommand_refund::GetHelp()
{
	return "REFUND <id> <credits> - Give a player a specified amount of credits back.\n";
}

void ConsoleCommand_refund::Activate(const char *CommandLine)
{	if (!CommandLine) return;
	if (stricmp(CommandLine, "") == 0)
	{
		Console_Output("REFUND <id> <credits>\n");
		return;
	}
	TokenClass Cmd(CommandLine);
	if (Cmd[0].empty()) { return; }
	if (Cmd[1].empty()) { return; }
	if (Cmd[2].empty()) { return; }
	int pID = atoi(Cmd[1].c_str());
	float money = (float)atof(Cmd[2].c_str());
	GameObject *player = Get_GameObj(pID);
	Commands->Give_Money(player,money,false);
	Console_Output("%ls has been refunded %f credits.\n",Get_Wide_Player_Name(player),money);
}

//************************************************
//**********  SETCREDITS CONSOLE CMD  ************
//************************************************

const char *ConsoleCommand_setcredits::GetName()
{
	return "setcredits";
}

const char *ConsoleCommand_setcredits::GetAlias()
{
	return NULL;
}

const char *ConsoleCommand_setcredits::GetHelp()
{
	return "SETCREDITS <id> <amount> - Set a player's credits to a specified amount.\n";
}

void ConsoleCommand_setcredits::Activate(const char *CommandLine)
{	if (!CommandLine) return;
	if (stricmp(CommandLine, "") == 0)
	{
		Console_Output("SETCREDITS <id> <amount>\n");
		return;
	}
	TokenClass Cmd(CommandLine);
	if (Cmd[0].empty()) { return; }
	if (Cmd[1].empty()) { return; }
	if (Cmd[2].empty()) { return; }
	int pID = atoi(CommandLine);
	int pID2 = atoi(Cmd[1].c_str());
	GameObject *player = Get_GameObj(pID2);
	float credits = (float)atof(Cmd[2].c_str());
	Set_Money(pID,credits);
	Console_Output("%ls's credits has been set to %f.\n",Get_Wide_Player_Name(player),credits);
}

//************************************************
//**********  SETPOINTS CONSOLE CMD  *************
//************************************************


const char *ConsoleCommand_setpoints::GetName()
{
	return "setpoints";
}

const char *ConsoleCommand_setpoints::GetAlias()
{
	return NULL;
}

const char *ConsoleCommand_setpoints::GetHelp()
{
	return "SETPOINTS <id> <amount> - Set a player's points to a specified amount.\n";
}

void ConsoleCommand_setpoints::Activate(const char *CommandLine)
{	if (!CommandLine) return;
	if (stricmp(CommandLine, "") == 0)
	{
		Console_Output("SETPOINTS <id> <amount>\n");
		return;
	}
	TokenClass Cmd(CommandLine);
	if (Cmd[0].empty()) { return; }
	if (Cmd[1].empty()) { return; }
	if (Cmd[2].empty()) { return; }
	int pID = atoi(CommandLine);
	int pID2 = atoi(Cmd[1].c_str());
	GameObject *player = Get_GameObj(pID2);
	float points = (float)atof(Cmd[2].c_str());
	Set_Score(pID,points);
	Console_Output("%ls's points has been set to %f.\n",Get_Wide_Player_Name(player),points);
}

//************************************************
//**********  TELEPORT CONSOLE CMD  **************
//************************************************

const char *ConsoleCommand_teleport::GetName()
{
	return "teleport";
}

const char *ConsoleCommand_teleport::GetAlias()
{
	return NULL;
}

const char *ConsoleCommand_teleport::GetHelp()
{
	return "TELEPORT <id> <vector3> - Move a player to a specific XYZ coordinate.\n";
}

void ConsoleCommand_teleport::Activate(const char *CommandLine)
{	
	if (!CommandLine) return;
	if (stricmp(CommandLine, "") == 0)
	{
		Console_Output("TELEPORT <id> <vector3>\n");
		return;
	}
	TokenClass Cmd(CommandLine);
	if (Cmd[0].empty()) { return; }
	if (Cmd[1].empty()) { return; }
	if (Cmd[2].empty()) { return; }
	if (Cmd[3].empty()) { return; }
	if (Cmd[4].empty()) { return; }
	int pID = atoi(Cmd[1].c_str());
	float posX = (float)atof(Cmd[2].c_str());
	float posY = (float)atof(Cmd[3].c_str());
	float posZ = (float)atof(Cmd[4].c_str());
	GameObject *player = Get_GameObj(pID);
	Vector3 pos = Commands->Get_Position(player);
	Vector3 newpos;
	newpos.X = posX;
	newpos.Y = posY;
	newpos.Z = posZ;
	Commands->Set_Position(player,newpos);
	Console_Output("%ls has been moved to %f %f %f\n",Get_Wide_Player_Name(player),newpos.X,newpos.Y,newpos.Z);
}

//************************************************
//***********  UNFREEZE CONSOLE CMD  *************
//************************************************

const char *ConsoleCommand_unfreeze::GetName()
{
	return "unfreeze";
}

const char *ConsoleCommand_unfreeze::GetAlias()
{
	return NULL;
}

const char *ConsoleCommand_unfreeze::GetHelp()
{
	return "UNFREEZE <id> - Allows an immobilized player to move again.\n";
}

void ConsoleCommand_unfreeze::Activate(const char *CommandLine)
{
	if (!CommandLine) return;
	if (stricmp(CommandLine, "") == 0)
	{
		Console_Output("UNFREEZE <id>\n");
		return;
	}
	TokenClass Cmd(CommandLine);
	if (Cmd[0].empty()) { return; }
	if (Cmd[1].empty()) { return; }
	int pID = atoi(Cmd[1].c_str());
	GameObject *player = Get_GameObj(pID);
	Commands->Control_Enable(player,true);
}
